/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.okhttp.internal.http;

import com.squareup.okhttp.internal.AbstractOutputStream;
import com.squareup.okhttp.internal.Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ProtocolException;

final class RetryableOutputStream
extends AbstractOutputStream {
    private final int limit;
    private final ByteArrayOutputStream content;

    public RetryableOutputStream(int limit) {
        this.limit = limit;
        this.content = new ByteArrayOutputStream(limit);
    }

    public RetryableOutputStream() {
        this.limit = -1;
        this.content = new ByteArrayOutputStream();
    }

    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.content.size() < this.limit) {
            throw new ProtocolException("content-length promised " + this.limit + " bytes, but received " + this.content.size());
        }
    }

    public synchronized void write(byte[] buffer, int offset, int count) throws IOException {
        this.checkNotClosed();
        Util.checkOffsetAndCount(buffer.length, offset, count);
        if (this.limit != -1 && this.content.size() > this.limit - count) {
            throw new ProtocolException("exceeded content-length limit of " + this.limit + " bytes");
        }
        this.content.write(buffer, offset, count);
    }

    public synchronized int contentLength() throws IOException {
        this.close();
        return this.content.size();
    }

    public void writeToSocket(OutputStream socketOut) throws IOException {
        this.content.writeTo(socketOut);
    }
}

